﻿<?xml version="1.0" encoding="UTF-8"?>
<?LassoScript
	/*
			This file functions much like the normal index.lasso file, except
		that it receives AJAX style requests only. Therefore it does not return
		a regular XHTML page, but only a part of a regular XHTML page. The
		returned section is then inserted into the calling document.
	*/
	var('LJAX' = true);

	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	// Include the library file which creates the required databases, tables and groups
	library('initialize.lasso');
	
	// When running as an LJAX request, these pages handle simple tasks such as
	// returning the next "page" of messages, or the submittal of a new message reply, etc.
	// All resulting data must be a valid XML document, at least as far as
	// the calling XMLHttpReqeust is concerned.
	// the proper content-type has already been set in the ../library.lasso file.
	
	'<ljax>';

		// Store the inputs to the page in variables.  The inputs include the 'section'
		// and 'page' which should be shown to the site visitor.  The 'mode' which can be
		// set to 'edit' in order to show the administration interface.  And, the 'action'
		// which is used within the administration interface on each submitted form.
		
		var: 'section' = (action_param: 'section', (action_param: 'section', -count));
		var: 'page' = (action_param: 'page', (action_param: 'page', -count));
		var: 'mode' = (action_param: 'mode', (action_param: 'mode', -count));
		var: 'action' = (action_param: 'action', (action_param: 'action', -count));
		
		// The variable 'handled' is set to true by one of the invidividual solution pages
		// when it has successfully handled the current request.  If none of the administration
		// pages handle the request then the page is shown using 'template.lasso' to the site
		// visitor.
		
		var: 'handled' = false;

		// Only an administrator or a member of the group 'OP Collaborate Admins' can access the
		// edit interface.  If the mode is 'edit' we prompt for their username and password.

		if: ($mode == 'edit');
			auth_group: (array: 'Administrators', 'OP Collaborate Admins');
		/if;
		
		// Create a new page if mode is 'edit' and 'page' is set to '$new$'.
		
		if: ($handled == false) && ($mode == 'edit') && ($page == '$new$');
			var: 'content' = (include: 'edit/page_new.lasso');
		/if;
		
		// Edit a page if mode is 'edit' and page is not empty.
		
		if: ($handled == false) && ($mode == 'edit') && ($page != '');
			var: 'content' = (include: 'edit/page_edit.lasso');
		/if;
		
		// Create a new section if mode is 'edit' and 'section' is set to '$new$'.

		if: ($handled == false) && ($mode == 'edit') && ($section == '$new$');
			var: 'content' = (include: 'edit/section_new.lasso');
		/if;

		// Edit a section if mode is 'edit' and section is not empty.
		
		if: ($handled == false) && ($mode == 'edit') && ($section != '');
			var: 'content' = (include: 'edit/section_edit.lasso');
		/if;
		
		// Edit the global preferences if mode is 'edit' and both page and section are empty.
		
		if: ($handled == false) && ($mode == 'edit');
			var: 'content' = (include: 'edit/site_edit.lasso');
		/if;
		
		if: ($handled == false);
			include: 'library.lasso';
			var: 'content' = (include: 'template/template.lasso');
		/if;
		
		// If an error occurred then the error page is shown
		if: (error_msg != error_noerror);
			var: 'content' = (include: 'error.lasso');
		/if;
	
		// Show the content that was created by the include above
		$content;	
		
	'</ljax>';
?>